/*******************************************************
Filename		:  di_community_sampled.sql
Release 		:  c2.0
SIR			:  1509
Description		:  Creates the dimension table DI_COMMUNITY_SAMPLED and related objects.
Author			:  Thieu Nguyen
Date			:  7/14/2003
Comments		:  
**********************************************************/

connect storetw/storetw@storet.sdc
spool di_community_sampled.log

drop sequence seq_community_sampled;

create sequence seq_community_sampled
start with 1 increment by 1 nomaxvalue nocycle cache 10;

drop table di_community_sampled;
create table di_community_sampled
(PK_ISN number(12) not null,
 ACTIVITY_COMMUNITY varchar2(30) not null)
tablespace storetdata
storage (initial 256K next 256K)
nologging;

alter table di_community_sampled
add constraint pk_community_sampled primary key (pk_isn)
using index
tablespace storetindx
storage (initial 128K next 128K);

--add data to di_community_sampled
set serveroutput on
declare
cursor c1 is select distinct ACTIVITY_COMMUNITY 
FROM fa_biological_result
where ACTIVITY_COMMUNITY is not null;

begin
for c1_var in c1 loop
insert into di_community_sampled(PK_ISN,ACTIVITY_COMMUNITY)
values(seq_community_sampled.nextval,c1_var.ACTIVITY_COMMUNITY);
end loop;
commit;
end;
/

--update fks in FA_BIOLOGICAL_RESULT
declare
cursor c1 is select * from di_community_sampled;

begin
for c1_var in c1 loop
update FA_BIOLOGICAL_RESULT
set FK_COMMUNITY_SAMPLED = c1_var.pk_isn
where ACTIVITY_COMMUNITY = c1_var.ACTIVITY_COMMUNITY;
commit;
end loop;
commit;
end;
/
spool off;
